local t = Def.ActorFrame {};

-- A very useful table...
local eval_lines = {
	"W1",
	"W2",
	"W3",
	"W4",
	"W5",
	"Miss",
	"MaxCombo"
}

local eval_radar = {
	Types = { 'Holds', 'Rolls', 'Hands', 'Mines', 'Lifts' },
}

local grade_area_offset = 16
local fade_out_speed = 0.3
local fade_out_pause = 0.08

-- And a function to make even better use out of the table.
local function GetJLineValue(line, pl)
	if line == "Held" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetHoldNoteScores("HoldNoteScore_Held")
	elseif line == "MaxCombo" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):MaxCombo()
	else
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetTapNoteScores("TapNoteScore_" .. line)
	end
	return "???"
end

-- You know what, we'll deal with getting the overall scores with a function too.
local function GetPlScore(pl, scoretype)
	local primary_score = FormatPercentScore(STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetPercentDancePoints())
	local secondary_score = STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetScore()
	
	if scoretype == "primary" then
		return primary_score
	else
		return secondary_score
	end
end

-- #################################################
-- That's enough functions; let's get this done.

-- Shared portion.
local mid_pane = Def.ActorFrame {
	Def.Sprite {
		Texture="_pod";
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y+30)
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;		
	},	
	Def.Sprite {
		InitCommand=function(self)
			self:xy(_screen.cx,_screen.cy+30)
			local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
			if GAMESTATE:IsCourseMode() then
				if target:HasBanner() then
					self:Load(target:GetBannerPath())
					self:scaletoclipped(256,80):zoom(0.75)		
				else
					self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(256,80):zoom(0.75)
				end;
			else
				if target and target:HasJacket() then
					self:Load(target:GetJacketPath())
					self:scaletoclipped(194,194)	
				elseif target:HasBackground() then
					self:Load(target:GetBackgroundPath())
					self:scaletoclipped(194,194)	
				elseif target:HasBanner() then
					self:Load(target:GetBannerPath())
					self:scaletoclipped(256,80):zoom(0.75)		
				else
					self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(256,80):zoom(0.75)
				end;
			end;
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	},
	Def.BitmapText {
			Font="Common Normal",
			InitCommand=function(self)
				self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-105):diffuse(color("#FFFFFF")):zoom(0.5):maxwidth(180/0.5)
			end;
			Text=GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() or GAMESTATE:GetCurrentSong():GetDisplayMainTitle();
			OnCommand=function(self)
				if not GAMESTATE:IsCourseMode() then
					local song = GAMESTATE:GetCurrentSong();
					if song then
						if song:GetDisplaySubTitle() ~= "" then
							self:addy(-10)
						end
					end;
				end;
			end;
			OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
		},
		Def.BitmapText {
			Font="Common Normal",
			InitCommand=function(self)
				self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-99):zoom(0.4):maxwidth(180/0.4)
			end;
			Text=GAMESTATE:IsCourseMode() and "" or GAMESTATE:GetCurrentSong():GetDisplaySubTitle();
			OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
		},
};


t[#t+1] = mid_pane

-- #################################################
-- Time to deal with all of the player stats. ALL OF THEM.

local eval_parts = Def.ActorFrame {}

for ip, p in ipairs(GAMESTATE:GetHumanPlayers()) do
	-- Some things to help positioning
	local step_count_offs = string.find(p, "P1") and -165 or 165+64
	local grade_parts_offs = string.find(p, "P1") and -199 or 199
	local options_location = string.find(p, "P1") and SCREEN_CENTER_X-192 or SCREEN_CENTER_X+192
	local p_grade = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetGrade()

	-- Step counts.
	for i, v in ipairs(eval_lines) do
		local spacing = 20*i
		local cur_line = "JudgmentLine_" .. v

		eval_parts[#eval_parts+1] = Def.ActorFrame {
		InitCommand=function(self) 	self:x(_screen.cx + step_count_offs):y((_screen.cy/2.1)+(spacing)) end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
			-- BG
			--Def.Quad {
			--	InitCommand=function(self) self:zoomto(220,32):diffuse(BoostColor(ColorMidTone(JudgmentLineToColor(cur_line)),0.6)) end;
			--  OnCommand=function(self)
			--		self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(0.9)
			--	end;
			--};
			-- Item name
			Def.BitmapText {
				Font = "Common Normal",
				InitCommand=function(self) self:x(-104):zoom(0.5):diffuse(color("#FFFFFF")):settext(string.upper(JudgmentLineToLocalizedString(cur_line))):horizalign(left) end;
				OnCommand=function(self)
					self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(1)
				end;
			};
			-- Arrow
			Def.Sprite {
				Texture="_tri";
				InitCommand=function(self) self:x(-20):diffuse(JudgmentLineToColor(cur_line)) end;			
				OnCommand=function(self)
					self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(1):addx(5)
				end;
			};
			-- Numbers numbers numbers!
			Def.BitmapText {
				Font = "Common Normal",
				InitCommand=function(self)
					self:diffuse(color("#FFFFFF"))
					self:zoom(0.5):diffusealpha(1.0):shadowlength(1):maxwidth(120):horizalign(right):x(36)
				end;
				OnCommand=function(self)
					self:settext(GetJLineValue(v, p))
					self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(1)
				end;
			};
		};
	end
	

	-- Letter grade and associated parts.
	eval_parts[#eval_parts+1] = Def.Sprite{
			Texture=THEME:GetPathG("GradeDisplay", "Grade " .. p_grade);
			InitCommand=function(self)
				self:horizalign(center):xy(_screen.cx + grade_parts_offs-40,_screen.cy+51)		   
				self:zoom(0.3)
			end;
			OnCommand=function(self)
				self:diffusealpha(0):sleep(1):decelerate(0.3):diffusealpha(1)
			end;
			OffCommand=function(self)
			    self:decelerate(0.4):diffusealpha(0):addy(4)
			end;
	};

	-- Primary score.
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common normal",
		InitCommand=function(self)
			self:horizalign(right):x(_screen.cx + (step_count_offs)+4):y(_screen.cy+43):addx(36)
			self:diffuse(color("#D6AC24")):zoom(0.5):shadowlength(1):maxwidth(180)
		end;
		OnCommand=function(self)
			self:settext(GetPlScore(p, "primary")):diffusealpha(0):sleep(1.2):decelerate(0.3):diffusealpha(1)
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	}		
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common normal",
		InitCommand=function(self)
			self:horizalign(right):x(_screen.cx + (step_count_offs)+4):y(_screen.cy+45+15):addx(36)
			self:diffuse(color("#D6AC24")):zoom(0.5):shadowlength(1):maxwidth(80)
		end;
		OnCommand=function(self) self:settext(GetPlScore(p, "secondary")):diffusealpha(0):sleep(1.3):decelerate(0.3):diffusealpha(1)
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	}
	
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common normal",
		InitCommand=function(self)
			self:horizalign(left):x(_screen.cx + (step_count_offs)-37):y(_screen.cy+43)
			self:diffuse(color("#D6AC24")):zoom(0.5):shadowlength(1):maxwidth(180)
		end;
		OnCommand=function(self)
			self:diffusealpha(0):sleep(1.2):decelerate(0.3):diffusealpha(1)
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
		Text="Rate:";
	}	
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common normal",
		InitCommand=function(self)
			self:horizalign(left):x(_screen.cx + (step_count_offs)-37):y(_screen.cy+45+15)
			self:diffuse(color("#D6AC24")):zoom(0.5):shadowlength(1):maxwidth(180)
		end;
		OnCommand=function(self)
			self:diffusealpha(0):sleep(1.3):decelerate(0.3):diffusealpha(1)
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
		Text="Score:";
	}	
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common Normal",
		InitCommand=function(self)
			self:vertalign(bottom):x(options_location):y(_screen.cy+190):wrapwidthpixels(160/0.4):maxwidth(160/0.4)
			self:diffuse(Color.White):zoom(0.4):diffusealpha(0.6)
		end;
		OnCommand=function(self)
			self:settext(GAMESTATE:GetPlayerState(p):GetPlayerOptionsString(0))
			end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	};

	-- Other stats (holds, mines, etc.)
	for i, rc_type in ipairs(eval_radar.Types) do
		local performance = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetRadarActual():GetValue( "RadarCategory_"..rc_type )
		local possible = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetRadarPossible():GetValue( "RadarCategory_"..rc_type )
		local label = THEME:GetString("RadarCategory", rc_type)
		local spacing = 16*i

		eval_parts[#eval_parts+1] = Def.ActorFrame {
			InitCommand=function(self) 	self:x(_screen.cx + step_count_offs):y((_screen.cy*1.30)+(spacing)) end;
			OnCommand=function(self)
				self:diffusealpha(0):sleep(0.1 * i):decelerate(0.5):diffusealpha(1)
			end;
			OffCommand=function(self)
				self:decelerate(0.4):diffusealpha(0):addy(4)
			end;
				-- Item name
				Def.BitmapText {
					Font = "Common normal",
					InitCommand=function(self)
						self:zoom(0.5):x(-104):horizalign(left):diffuse(color("#9D9E9D")):shadowlength(1):uppercase(true)
					end;
					BeginCommand=function(self)
						self:settext(label)
					end;
				};
				-- Value
				Def.BitmapText {
				Font = "Common normal",
				InitCommand=function(self)
					self:diffuse(color("#FFFFFF"))
					self:zoom(0.5):diffusealpha(1.0):shadowlength(1):maxwidth(120):horizalign(right):x(36)
				end;
				BeginCommand=function(self)
					self:settext(performance .. "/" .. possible)
				end
				};
		};
	end;

	-- Options
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common normal",
		InitCommand=function(self)
			self:horizalign(center):vertalign(bottom):x(_screen.cx + (grade_parts_offs)):y(_screen.cy+196+92):wrapwidthpixels(240)
			self:diffuse(Color.White):zoom(0.75):shadowlength(2)
		end;
		OnCommand=function(self)
			self:settext(GAMESTATE:GetPlayerState(p):GetPlayerOptionsString(0))
			self:diffusealpha(0):sleep(0.8):decelerate(0.6):diffusealpha(1)
			end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
		};
end

t[#t+1] = eval_parts;

for ip, p in ipairs(GAMESTATE:GetHumanPlayers()) do
	local grade_parts_offs = string.find(p, "P1") and -195 or 195
		-- Some things to help positioning
		t[#t+1] = LoadFont("Common normal") .. {
			InitCommand=function(self)
				self:horizalign(center):xy(_screen.cx + grade_parts_offs,_screen.cy-126)		   
				self:diffuse(color("#FFFFFF")):zoom(0.65):maxwidth(160)
			end;
			OnCommand=function(self) self:playcommand("Set") end;
			["CurrentSteps"..ToEnumShortString(p).."ChangedMessageCommand"]=function(self) self:playcommand("Set") end;
			ChangedLanguageDisplayMessageCommand=function(self) self:playcommand("Set") end;
			SetCommand=function(self)
			if GAMESTATE:IsCourseMode() ~= true then
				local steps_data = GAMESTATE:GetCurrentSteps(p)
				local song = GAMESTATE:GetCurrentSong();
				if song and steps_data ~= nil then
					local st = steps_data:GetStepsType();
					local diff = steps_data:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))) .. "  " .. steps_data:GetMeter());
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
				end
			else
				local course = GAMESTATE:GetCurrentCourse();
				local steps_data = GAMESTATE:GetCurrentTrail(p);
				if course and steps_data ~= nil then
					  local st = steps_data:GetStepsType();
					  local diff = steps_data:GetDifficulty();
					  local courseType = course:GetCourseType();
					  local cd = GetCustomDifficulty(st, diff, courseType);
					  self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))));
					  self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
				end
			end;
			end;
			OffCommand=function(self)
				self:decelerate(0.4):diffusealpha(0):addy(4)
			end;
		};
end;

for ip, p in ipairs(GAMESTATE:GetHumanPlayers()) do
	-- Some things to help positioning
	local badge_offs = string.find(p, "P1") and -50 or 50
	-- bases (PB)
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+158):x(SCREEN_CENTER_X+(badge_offs)) end;
		Texture="badge_base";
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};	
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+158):x(SCREEN_CENTER_X+(badge_offs)):diffuse(PlayerColor(p)) end;
		Texture="_pb";
		OnCommand=function(self)
			local record = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetPersonalHighScoreIndex()
			local hasPersonalRecord = record ~= -1
			self:visible(hasPersonalRecord);
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};	
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+158):x(SCREEN_CENTER_X+(badge_offs)) end;
		Texture="_best";
		OnCommand=function(self)
			local record = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetPersonalHighScoreIndex()
			local hasPersonalRecord = record ~= -1
			self:visible(hasPersonalRecord);
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
	t[#t+1] = Def.BitmapText {
		Font = "Common Normal";
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+154+6):x(SCREEN_CENTER_X+(badge_offs)):zoom(0.65):strokecolor(color("#000000")) end;
		OnCommand=function(self)
			local record = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetPersonalHighScoreIndex()
			local hasPersonalRecord = record ~= -1
			self:visible(hasPersonalRecord);
			self:settext("#" .. record+1)
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
	-- bases (FC)
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+188):x(SCREEN_CENTER_X+(badge_offs)) end;
		Texture="badge_base";
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
	t[#t+1] = Def.Sprite {
		Texture="_fc";
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+188):x(SCREEN_CENTER_X+(badge_offs)) end;
		OnCommand=function(self)
				local plstats = STATSMAN:GetCurStageStats():GetPlayerStageStats(p)
				if (plstats:FullComboOfScore('TapNoteScore_W1') == true) then
					self:visible(true):diffuse(color("#84FCFF"))
				elseif (plstats:FullComboOfScore('TapNoteScore_W2') == true) then
					self:visible(true):diffuse(color("#A4CBE9"))	
				elseif (plstats:FullComboOfScore('TapNoteScore_W3') == true) then
					self:visible(true):diffuse(color("#8CED91"))
				else
					self:visible(false)
				end;
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};	
	end;

-- Stage count
if not GAMESTATE:IsCourseMode() then
	t[#t+1] = LoadActor(THEME:GetPathG("ScreenEvaluation", "StageDisplay")) .. {
		InitCommand=function(self) self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-132):visible(not GAMESTATE:HasEarnedExtraStage()):zoom(0.5) end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
else
	t[#t+1] = Def.BitmapText {
		Font="Common Normal",
		InitCommand=function(self) 
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-132) 
			self:diffuse(color("#F7E16E")):zoom(0.5):maxwidth(180/0.5)
		end;
		OnCommand=function(self) self:playcommand("Set") end;
		SetCommand=function(self)
			local course = GAMESTATE:GetCurrentCourse()
			self:settext(CourseTypeToLocalizedString(course:GetCourseType()))
			-- StepMania is being stupid so we have to do this here;
			self:diffusealpha(0):smooth(0.3):diffusealpha(1);
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
end;

if GAMESTATE:HasEarnedExtraStage() then
	t[#t+1] =  Def.BitmapText {
		InitCommand=function(self) 
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-132):visible(not GAMESTATE:HasEarnedExtraStage()) 
			self:diffuse(color("#C54039")):zoom(0.5):maxwidth(180/0.5)
		end;
		Font="Common Normal";
		Text=string.upper(THEME:GetString("ScreenEvaluation", "ExtraUnlocked"));
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
end;

--t[#t+1] = StandardDecorationFromFileOptional("LifeDifficulty","LifeDifficulty");
--t[#t+1] = StandardDecorationFromFileOptional("TimingDifficulty","TimingDifficulty");

return t;
